/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public final class LogoProperties {
    private static LogoProperties fSingletonInstance = null;
    private static String fFileName;
    private Properties fProperties = null;

    private LogoProperties() {
        String propertyFile = null;
        propertyFile = LogoProperties.getUserPropertyFileName();
        if (!this.loadProperties(propertyFile) && !this.loadProperties(propertyFile = LogoProperties.getPropertyFileName())) {
            System.out.println("No properties found!");
        }
    }

    public static String findFileInClassPath(String fileName) {
        String totalString;
        block4: {
            String helpStr;
            int index;
            totalString = null;
            int lastIndex = 0;
            String NOTFOUND = "not found";
            String pathSeparator = System.getProperty("path.separator", "not found");
            String fileSeparator = System.getProperty("file.separator", "\\");
            String classPath = System.getProperty("java.class.path", "not found");
            if (pathSeparator.equals("not found") || classPath.equals("not found")) break block4;
            while ((index = classPath.indexOf(pathSeparator, lastIndex)) != -1) {
                helpStr = classPath.substring(lastIndex, index);
                if (LogoProperties.testFileAvailable(helpStr) && helpStr.substring(helpStr.length() - fileName.length()).equalsIgnoreCase(fileName)) {
                    totalString = helpStr;
                    break block4;
                }
                if (LogoProperties.testFileAvailable(helpStr = helpStr + fileSeparator + fileName)) {
                    totalString = helpStr;
                    break block4;
                }
                lastIndex = index + 1;
            }
            helpStr = classPath.substring(lastIndex);
            if (LogoProperties.testFileAvailable(helpStr = helpStr + fileSeparator + fileName)) {
                totalString = helpStr;
            }
        }
        return totalString;
    }

    private static boolean testFileAvailable(String fileName) {
        try {
            File f = new File(fileName);
            return f.isFile();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String propValue = this.fProperties.getProperty(key);
        if (propValue != null) {
            try {
                return new Boolean(propValue);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public double getDoubleProperty(String key, double defaultValue) {
        String propValue = this.fProperties.getProperty(key);
        if (propValue != null) {
            try {
                return Double.parseDouble(propValue);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public int getIntProperty(String key, int defaultValue) {
        String propValue = this.fProperties.getProperty(key);
        if (propValue != null) {
            try {
                return Integer.parseInt(propValue);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static Properties getProperties(String fileName) {
        String propertyFile = null;
        propertyFile = new File(fileName).isAbsolute() ? fileName : LogoProperties.findFileInClassPath(fileName);
        if (propertyFile != null) {
            try {
                Properties addProps = new Properties();
                FileInputStream appStream = new FileInputStream(propertyFile);
                addProps.load(appStream);
                appStream.close();
                return addProps;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public Properties getProperties() {
        return this.fProperties;
    }

    public String getProperty(String key) {
        return this.fProperties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.fProperties.getProperty(key, defaultValue);
    }

    public boolean getProperty(String key, boolean defaultValue) {
        String propValue = this.fProperties.getProperty(key);
        if (propValue != null) {
            try {
                return new Boolean(propValue);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private static String getPropertyFileName() {
        return "Application.ini";
    }

    public static String getUserPropertyFileName() {
        Version v = Version.getCurrentVersion();
        return System.getProperty("user.home", "") + "/." + v.getApplicationFileName() + v.getMajorVersion() + "." + v.getMinorVersion() + "/" + "Application.ini";
    }

    public static LogoProperties instance() {
        if (fSingletonInstance == null) {
            fSingletonInstance = new LogoProperties();
        }
        return fSingletonInstance;
    }

    public boolean loadProperties(String propertyFile) {
        try {
            this.fProperties = new Properties();
            FileInputStream appStream = new FileInputStream(propertyFile);
            this.fProperties.load(appStream);
            appStream.close();
            return true;
        }
        catch (IOException ioe) {
            System.out.println("loading " + propertyFile + " failed");
            return false;
        }
    }

    public Object removePropertyKey(String propertyKey) {
        return this.fProperties.remove(propertyKey);
    }

    public void saveProperties() {
        String propertyFileName = LogoProperties.getUserPropertyFileName();
        File propertyFile = new File(propertyFileName);
        if (!propertyFile.isAbsolute()) {
            propertyFile = new File(LogoProperties.findFileInClassPath(propertyFileName));
        }
        if (propertyFile != null) {
            try {
                if (!propertyFile.getAbsoluteFile().getParentFile().exists()) {
                    propertyFile.getAbsoluteFile().getParentFile().mkdirs();
                }
                FileOutputStream appStream = new FileOutputStream(propertyFile);
                this.fProperties.store(appStream, Application.getName() + " Properties");
                appStream.close();
            }
            catch (IOException e) {
                Log.println("log.err.writeProtected", "To store your settings the file '" + propertyFile + "' must be writetable");
            }
        }
    }

    public static void saveProperties(Properties properties, String fileName) throws IOException {
        File propertyFile = new File(fileName);
        if (!propertyFile.isAbsolute()) {
            propertyFile = new File(LogoProperties.findFileInClassPath(fileName));
        }
        if (propertyFile != null) {
            if (!propertyFile.getAbsoluteFile().getParentFile().exists()) {
                propertyFile.getAbsoluteFile().getParentFile().mkdirs();
            }
            FileOutputStream appStream = new FileOutputStream(propertyFile);
            properties.store(appStream, "LogoSoftComfort DefaultProperties");
            appStream.close();
        }
    }

    public Object setBooleanProperty(String key, boolean value) {
        return this.fProperties.setProperty(key, new Boolean(value).toString());
    }

    public static void setFileName(String fileName) {
        fFileName = fileName;
    }

    public void setIntProperty(String key, int value) {
        this.setProperty(key, String.valueOf(value));
    }

    public Object setProperty(String key, String value) {
        if (key.equals("logo.file1")) {
            return this.sortFilenames(value);
        }
        return this.fProperties.setProperty(key, value);
    }

    public Object sortFilenames(String value) {
        String oldKey = value;
        for (int i = 1; i <= 4 && (oldKey = (String)this.fProperties.setProperty("file" + i, oldKey)) != null && !oldKey.equals(value); ++i) {
        }
        return oldKey;
    }

    public void setProperties(Properties properties) {
        this.fProperties = properties;
    }
}

